﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class SetProjectorToShader : MonoBehaviour
{
    public Camera mainCam;
    public Material mat;
    public int Resolution;

    Vector2 scale;

    private void Start()
    {
        if (GetComponent<AudioListener>() != null) GetComponent<AudioListener>().enabled = false;
        mainCam = GameObject.FindGameObjectWithTag("MainCamera").GetComponent<Camera>();
    }

    private void Update()
    {
        if (GetComponent<Transform>().parent != null)
        {
            scale.x = GetComponent<Transform>().parent.localScale.x;
            scale.y = GetComponent<Transform>().parent.localScale.z;
            Shader.SetGlobalVector("_SkillIndicatorSize", scale);
        }
        else
        {
            scale.x = GetComponent<Transform>().localScale.x;
            scale.y = GetComponent<Transform>().localScale.z;
            Shader.SetGlobalVector("_SkillIndicatorSize", scale);
        }
    }

    private void OnDisable()
    {
        Shader.SetGlobalFloat("_SkillIndicatorOffOn", 0);
        if (!mainCam) return;
        mainCam.GetComponent<UpdateProjectorRT>().RenderOffOn = false;
        mainCam.GetComponent<UpdateProjectorRT>().ReleaseRT();
    }

    private void OnEnable()
    {
        mainCam = GameObject.FindGameObjectWithTag("MainCamera").GetComponent<Camera>();
        mainCam.GetComponent<UpdateProjectorRT>().cam = this.GetComponent<Camera>();
        mainCam.GetComponent<UpdateProjectorRT>().mat = this.mat;
        mainCam.GetComponent<UpdateProjectorRT>().Resolution = this.Resolution;
        mainCam.GetComponent<UpdateProjectorRT>().CreateRT();
        mainCam.GetComponent<UpdateProjectorRT>().RenderOffOn = true;
    }
}
